
<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-md-12">
		<div class="panel panel-default">
			<div class="panel-heading">
				<span class="panel-title" >
					<?php echo e(_lang('Student Attendance Report')); ?>

				</span>
			</div>
			<div class="panel-body">
				<form id="search_form" class="params-panel validate" action="<?php echo e(url('reports/student_attendance_report/view')); ?>" method="post" autocomplete="off" accept-charset="utf-8">
					<?php echo csrf_field(); ?>
					<div class="col-sm-3">
						<div class="form-group">
							<label class="control-label"><?php echo e(_lang('Floor')); ?></label>
							<select name="class_id" class="form-control select2" onChange="getData(this.value);" required>
								<option value=""><?php echo e(_lang('Select One')); ?></option>
								<?php echo e(create_option('classes','id','class_name',$class_id)); ?>

							</select>
						</div>
					</div>
					<div class="col-sm-3">
						<div class="form-group">
							<label class="control-label"><?php echo e(_lang('Room')); ?></label>
							<select name="section_id" class="form-control select2" required>
								<option value=""><?php echo e(_lang('Select One')); ?></option>
								<?php echo e(create_option('sections','id','section_name',$section_id,array("class_id="=>$class_id))); ?>

							</select>
						</div>
					</div>
					
					<div class="col-sm-3">
						<div class="form-group">
							<label class="control-label"><?php echo e(_lang('Month')); ?></label>
							<div class="input-group">
								<span class="input-group-addon"><i class="glyphicon glyphicon-calendar"></i></span>
								<input type="text" class="form-control monthpicker" name="month" value="<?php echo e($month); ?>" readOnly="true" required>
						    </div>
						</div>
					</div>
					

					<div class="col-sm-3">
						<div class="form-group">
							<button type="submit" style="margin-top:24px;" class="btn btn-primary btn-block rect-btn"><?php echo e(_lang('View Report')); ?></button>
						</div>
					</div>
				</form>
				
				<?php if( isset($report_data) ): ?>	
				<div class="col-md-12 params-panel" id="attendance">
                    <button type="button" data-print="attendance" class="btn btn-primary btn-sm pull-right print"><i class="fa fa-print"></i> <?php echo e(_lang('Print Report')); ?></button>			
						<div class="text-center clear">
							<?php echo e(get_option('school_name')); ?><br>
							<?php echo e(_lang('Attendance Report for Floor')); ?> <?php echo e($class); ?><br>
							<?php echo e(_lang('Room')." ".$section); ?> </br>
							<?php echo e($month); ?></br></br>	
						</div>
						
					   <div class="table-responsive"> 
					    <?php if( !empty($report_data) ): ?>
							<table class="table table-bordered">
								<thead>
								   <th><?php echo e(_lang('Student Name')); ?></th>
								   <th><?php echo e(_lang('Roll')); ?></th>
								   <?php for($day = 1; $day <= $num_of_days; $day++): ?>
									  <th><?php echo e($day); ?></th>
								   <?php endfor; ?>
								</thead>
								<tbody>
								  <?php $__currentLoopData = $report_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								   <tr>
									 <td><?php echo e($students[$key]->first_name." ".$students[$key]->last_name); ?></td>
									 <td><?php echo e($students[$key]->roll); ?></td>
									 <?php $__currentLoopData = $value; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student=>$attendance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<td class="text-center"><?php echo e($attendance); ?></td> 
									 <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								   </tr>
								  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</tbody>
							</table>
						<?php else: ?>	
							<h4 class="text-center"><?php echo e(_lang('No Records Found !')); ?></h4>
						<?php endif; ?>	
					   </div>
						
					</div>
				<?php endif; ?>
				</div><!--End panel-->
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script type="text/javascript">
	function getData(val) {
		var _token=$('input[name=_token]').val();
		var class_id=$('select[name=class_id]').val();
		$.ajax({
			type: "POST",
			url: "<?php echo e(url('sections/section')); ?>",
			data:{_token:_token,class_id:class_id},
			beforeSend: function(){
				$("#preloader").css("display","block");
			},success: function(sections){
				$("#preloader").css("display","none");
				$('select[name=section_id]').html(sections);				
			}
		});
	}

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\htdocs\hostel\resources\views/backend/reports/student_attendance_report.blade.php ENDPATH**/ ?>